﻿# Navigate between files in the `Files` folder?

Due to the complete reworking of the mod, I think I should explain how to navigate between files if you happen to want an individual script for mods that support `NFS Carbon Performance Reworking`.

---

## 🔍 How to navigate?

When you enter the files folder you will see several folders:

- Installer: Files\Dependencies for the `All in 1`, `Optionals`, and `Car Conversion` scripts
- Optionals: Scripts for optional features (they also work without installing the mod first)
- Reworking: This is the folder that contains the Individual Scripts. In this folder you will see:
  - `CarbonBattleRoyale`
  - `CarConverions`
  - `Endgame`
  - `ImprovementModV2`
  - `Vanilla`

In the vanilla folder are all the car scripts, which can be removed from the folder and continue working correctly, but the files in the other folders depend completely on the vanilla folder, which means that if the `Endgame` files, for example, were to be moved, they would stop working because those files are just a compatibility patch so that the mod works with most of the mods with which it is compatible.

Inside the other folders, you will see the versions of `OGVI` and `VlTed`, the folder that contains the compatibility scripts with the other mods, you will see that they have folders with a `_`, that means that the car script has an `exclusive bodykit` for the mod in the folder you are in at that moment.

There is also the case where you know the car has a dedicated `body kit`, but it is not in the folder or it is in the folder without the `-` in front of the folder name, this is because it is just a compatibility file and the vanilla file is already optimized for the new `body kit`, as it does not conflict when installing it.

## 🛠️ How to install it?

### Let's Start with the Vanilla Files

`Vanilla` files can be installed like any other `.nfsms` script. You can, if you wish, move it to the desktop and install it. It will install correctly.

### Now for the Compatibility Scripts

`Compatibility scripts` are installed just like the original scripts; there are no differences. However, you'll notice that there are `missing files` in the folders, but they only contain the scripts that cause problems when installing with mods, such as `Endgame`. Not all scripts in the `Vanilla` folder are compatible with mods. Therefore, if you want to install a script for a car that isn't in its corresponding folder, install it from the `Vanilla` folder, as it won't cause problems when installing with mods.

Inside the compatibility scripts there is a file address like this:
`..\..\Vanilla\OGVI\CarbonCars\Porsche911GT3RS\BETTER_997GT3RS.nfsms`

Around that line of code are the `compatibility modifications`, those files depend entirely on the files inside the `Vanilla` folder when moving them; removing them or not finding the script in the `Vanilla` folder the script will automatically throw an exception and will not install, if you wanted to install it with another address, `you can modify it by opening it as a notepad` with the right mouse click and modify the address to the script, on which, that script is depending.

---
